Profil = {                   
    FATHER = 100,
    HAMOUS = 63,
    PROF_ICECREAM = 162,
    RAT   = 81,
	VINCE = 69,
	STEVE = 80,
	JENNY = 132,
	DARREN = 87,
	TONY = 91,
	DEVIN = 61,
	CARMEN = 78,
}

Facts = {
	FACT_VINCE_EXPECTING_MONEY = 149,
	FACT_TONY_NOT_AVAILABLE = 86,
	FACT_DAVE_HAS_GAS = 226,
}

Flags2 = {
	PROFILE_MISC_FLAG2_DONT_ADD_TO_SECTOR = 0,
	PROFILE_MISC_FLAG2_LEFT_COUNTRY = 1,
	PROFILE_MISC_FLAG2_BANDAGED_TODAY = 2,
	PROFILE_MISC_FLAG2_SAID_FIRSTSEEN_QUOTE = 3,
	PROFILE_MISC_FLAG2_NEEDS_TO_SAY_HOSTILE_QUOTE = 4,
	PROFILE_MISC_FLAG2_MARRIED_TO_HICKS = 5,
	PROFILE_MISC_FLAG2_ASKED_BY_HICKS = 6,
}

Sectors = {
	HOSPITAL_SECTOR_X	= 8,
	HOSPITAL_SECTOR_Y	= 6,
	HOSPITAL_SECTOR_Z	= 0,
}

function HandleEarlyMorningEvents()

	for i = 57, 164 do
		-- set FALSE
		-- loop through all *NPCs* and reset "default response used recently" flags
		SetThreatenDefaultResponseUsedRecently(i,false)
		SetRecruitDefaultResponseUsedRecently(i,false)
		SetFriendlyOrDirectDefaultResponseUsedRecently(i,false)
		SetMiscFlags2(i,Flags2.PROFILE_MISC_FLAG2_BANDAGED_TODAY)
	end


	r = math.random(1, 4)
	SetNPCData1(Profil.FATHER,r)

	-- set Walker's location
	o = math.random(1, 2)
	if (o > 1) then
		--  move the father to the other sector, provided neither are loaded
	if  (not ( ( gWorldSectorX == 13) and ( ( gWorldSectorY == 3) or gWorldSectorY == 4 ) and ( gbWorldSectorZ == 0 ) ))  then

			SetCharacterSectorX(Profil.FATHER,13)
			id,SectorY = CheckCharacterSectorY(Profil.FATHER,3)
		
			-- swap his location
			if ( SectorY == 3 and id == 100 ) then
				SetCharacterSectorY(Profil.FATHER,4)
			else
				SetCharacterSectorY(Profil.FATHER,3)
			end
		end
	end


	TonySpoken = CheckLastDateSpokenTot(Profil.TONY)
	if (TonySpoken > 0 and not ( gWorldSectorX == 5 and gWorldSectorY == 3 and gWorldSectorZ == 0 )) then
	-- San Mona C5 is not loaded so make Tony possibly not available
	p = math.random(1, 4)

		if ( p > 1 ) then 
			-- Tony IS available
			SetFactFalse( Facts.FACT_TONY_NOT_AVAILABLE )
			AddNPCtoSector (Profil.TONY,5,3,0)
		else
			-- Tony is NOT available
			SetFactTrue( Facts.FACT_TONY_NOT_AVAILABLE )
			AddNPCtoSector (Profil.TONY,0,0,0)
		end
	end


	DevinSpoken = CheckLastDateSpokenTot(Profil.DEVIN)
	if ( DevinSpoken == 0 ) then

		DData = CheckNPCData1 (Profil.DEVIN)
		i = DData + 1
		SetNPCData1 (Profil.DEVIN,i)
		DevinData1 = CheckNPCData1 (Profil.DEVIN)

		if ( DevinData1 > 3 ) then
			Devinid,Devinx,Deviny,Devinz = CheckNPCinSector(Profil.DEVIN)
			if ( not ( (gWorldSectorX == Devinx) and (gWorldSectorY == Deviny) and (gWorldSectorZ == 0) ) ) then
				
				-- ok, Devin's sector not loaded, so time to move!
				-- might be same sector as before, if so, oh well!
				p = math.random(1, 5)
				if ( p == 1 ) then
					--G9
				AddNPCtoSector (Profil.DEVIN,9,7,0)
				elseif ( p == 2 ) then
					--D13
					AddNPCtoSector (Profil.DEVIN,13,4,0)		
				elseif ( p == 3 ) then
					--C5
					AddNPCtoSector (Profil.DEVIN,5,3,0)					
				elseif ( p == 4 ) then
					--H2
					AddNPCtoSector (Profil.DEVIN,2,8,0)	
				elseif ( p == 5 ) then
					--C6
					AddNPCtoSector (Profil.DEVIN,6,3,0)		
				end			
			end
		end
	end

	-- stop moving the truck if Hamous is dead!!
	-- stop moving them if the player has the truck or Hamous is hired!
	
	life = CheckNPCLife(Profil.HAMOUS)
	dHamous = CheckMercIsDead (Profil.HAMOUS)
	dIceTruck= CheckMercIsDead (Profil.PROF_ICECREAM)
	HAMOUSid,HAMOUSx,HAMOUSy,HAMOUSz = CheckNPCinSector(Profil.HAMOUS)

	if ( life > 0 and dHamous == false and dIceTruck == false and (not ( (gWorldSectorX == HAMOUSx) and (gWorldSectorY == HAMOUSy) and (gWorldSectorZ == 0) )) ) then

		-- ok, HAMOUS's sector not loaded, so time to move!
		-- might be same sector as before, if so, oh well!
		i = math.random(1, 5)
		if i == 1 then
			-- G6
			AddNPCtoSector (Profil.HAMOUS,6,7,0) 
			AddNPCtoSector (Profil.PROF_ICECREAM,6,7,0) 
		elseif i == 2 then
			-- F12
			AddNPCtoSector (Profil.HAMOUS,12,6,0) 
			AddNPCtoSector (Profil.PROF_ICECREAM,12,6,0) 
		elseif i == 3 then
			-- D7
			AddNPCtoSector (Profil.HAMOUS,7,4,0) 
			AddNPCtoSector (Profil.PROF_ICECREAM,7,4,0) 
		elseif i == 4 then
			-- D3
			AddNPCtoSector (Profil.HAMOUS,3,4,0) 
			AddNPCtoSector (Profil.PROF_ICECREAM,3,4,0) 
		elseif i == 5 then
			-- D9
			AddNPCtoSector (Profil.HAMOUS,9,4,0) 
			AddNPCtoSector (Profil.PROF_ICECREAM,9,4,0) 
		end
	end

	-- Does Rat take off?
	ratData1 = CheckNPCData1 (Profil.RAT)
	if (ratData1 > 0) then
		SetCharacterSectorX (Profil.RAT,0)
		SetCharacterSectorY (Profil.RAT,0)
		SetCharacterSectorZ (Profil.RAT,0)
	end
	
	-- Empty money from pockets of Vince 69, Willis 80, and Jenny 132
	SetMoneyInSoldierProfile( Profil.VINCE, 0 )
	SetMoneyInSoldierProfile( Profil.STEVE, 0 )
	SetMoneyInSoldierProfile( Profil.JENNY, 0 )

	-- Vince is no longer expecting money
	SetFactFalse( Facts.FACT_VINCE_EXPECTING_MONEY )

	-- Reset Darren's balance and money
	SetNPCBalance(Profil.DARREN,0)
	SetMoneyInSoldierProfile( Profil.DARREN, 15000 )
	
	-- set Carmen to be placed on the map in case he moved and is waiting off screen

	bool = CheckMiscFlags2(Profil.CARMEN,Flags2.PROFILE_MISC_FLAG2_DONT_ADD_TO_SECTOR)
	if bool == true then

		SetMiscFlags2(Profil.CARMEN, Flags2.PROFILE_MISC_FLAG2_DONT_ADD_TO_SECTOR)
	
		-- move Carmen to C13
		AddNPCtoSector (Profil.CARMEN,13,3,0) 

		--we should also reset # of terrorist heads and give him cash
		CarmenData2 = CheckNPCData2 (Profil.CARMEN)
		if CarmenData2 > 0 then
		
			Money = CheckMoney(Profil.CARMEN)
			
			if (Money < 10000 ) then	
				uiAmount = 0
			else
				uiAmount = Money
			end
			
			uiAmount = uiAmount + 10000 * CarmenData2
			SetMoneyInSoldierProfile( Profil.CARMEN, uiAmount )
			SetNPCData2(Profil.CARMEN,0)

			for i = 249, 254 do
				RemoveObjectFromSoldierProfile( Profil.CARMEN, i )
			end
		end
	else
		-- randomize where he'll be today... so long as his sector's not loaded
		CARMENid,CARMENx,CARMENy,CARMENz = CheckNPCinSector(Profil.CARMEN)
		if ( CARMENx ~= gWorldSectorX or CARMENy ~= gWorldSectorY ) then
			
				i = math.random(1, 3)
				if i == 1 then
					AddNPCtoSector (Profil.CARMEN,5,3,0) -- C5
				elseif i == 2 then
					AddNPCtoSector (Profil.CARMEN,13,3,0) -- C13
				elseif i == 3 then
					AddNPCtoSector (Profil.CARMEN,9,7,0) -- G9
				end
			
				-- he should have $5000... unless the player forgot to meet him
				Money = CheckMoney(Profil.CARMEN)
				if ( Money < 5000 ) then
					SetMoneyInSoldierProfile( Profil.CARMEN, 5000 )
				end	
		end
	end

	i = math.random(1, 3)	
	if i == 1 then
		SetFactTrue( Facts.FACT_DAVE_HAS_GAS )
	else
		SetFactFalse( Facts.FACT_DAVE_HAS_GAS )
	end	
	
	if ( gWorldSectorX == Sectors.HOSPITAL_SECTOR_X and gWorldSectorY == Sectors.HOSPITAL_SECTOR_Y and gWorldSectorZ == Sectors.HOSPITAL_SECTOR_Z ) then
		CheckForMissingHospitalSupplies()
	end

end